
#include <SPI.h>
#include <Ethernet.h>
#include <SD.h>
#include <Servo.h> 

  

// ===== Ethernet
  IPAddress ip(192, 168, 1, 31);   
  byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
  EthernetServer server(80);  
  File webFile;               // the web page file on the SD card
  #define REQ_BUF_SZ   60
  char HTTP_req[REQ_BUF_SZ] = {0}; // buffered HTTP request stored as null terminated string
  char req_index = 0;              // index into HTTP_req buffer

// ===== Power Relay

#define RELAY1  6

// ===== Servo
  Servo myservo;
  #define servo_pin 5


// ===== 74HC595
    byte latchPin = 7;  //Pin connected to ST_CP of 74HC595
    byte clockPin = 8; //Pin connected to SH_CP of 74HC595
    byte dataPin = 9;  //Pin connected to DS    of 74HC595


// ===== Kretnice
  // shrani stanje kretnic 
  // 0 = ravno / 1 = zavij / 2 = ravno + lock / 3 = zavij + lock
  int Kretnica_state[5] = {0}; 
  
  byte privzeto = B00001110; // privzeta vrednost kretnice 0 = active high, 1 = active low


void setup()
{
    // relay pin = output, relay = off
    pinMode(RELAY1, OUTPUT);  
    digitalWrite(RELAY1,HIGH);
    
    // disable Ethernet chip
    pinMode(10, OUTPUT);
    digitalWrite(10, HIGH);
    
    Serial.begin(9600);       // for debugging
    
    // initialize SD card
    Serial.println("Initializing SD card...");
    if (!SD.begin(4)) {
        Serial.println("ERROR - SD card initialization failed!");
        return;    // init failed
    }
    Serial.println("SUCCESS - SD card initialized.");
    // check for index.htm file
    if (!SD.exists("index.htm")) {
        Serial.println("ERROR - Can't find index.htm file!");
        return;  // can't find index file
    }
    Serial.println("SUCCESS - Found index.htm file.");
   
    Ethernet.begin(mac, ip);  // initialize Ethernet device
    server.begin();           // start to listen for clients
    
    
    // nastavi pine za 74HC595
    pinMode(latchPin, OUTPUT);
    pinMode(clockPin, OUTPUT);
    pinMode(dataPin, OUTPUT);
    
    // zapiše privzete vrednosti
    digitalWrite(latchPin, LOW);
    shiftOut(dataPin, clockPin, MSBFIRST, privzeto); 
    digitalWrite(latchPin, HIGH);   
   
    myservo.attach(servo_pin);
    myservo.detach(); 

   // Serial.println(privzeto);   
   
   // vklop napajanja / rele
   delay(100);
   digitalWrite(RELAY1,LOW);
}


void loop()
{
    EthernetClient client = server.available();  // try to get client

    if (client) {  // got client?
        boolean currentLineIsBlank = true;
        while (client.connected()) {
            if (client.available()) {   // client data available to read
                char c = client.read(); // read 1 byte (character) from client
                // limit the size of the stored received HTTP request
                // buffer first part of HTTP request in HTTP_req array (string)
                // leave last element in array as 0 to null terminate string (REQ_BUF_SZ - 1)
                if (req_index < (REQ_BUF_SZ - 1)) {
                    HTTP_req[req_index] = c;          // save HTTP request character
                    req_index++;
                }
                // last line of client request is blank and ends with \n
                // respond to client only after last line received
                if (c == '\n' && currentLineIsBlank) {
                    // send a standard http response header
                    client.println("HTTP/1.1 200 OK");
                    // remainder of header follows below, depending on if
                    // web page or XML page is requested
                    
                    // =====================================
                    // Ajax request - send XML file
                    // =====================================
                    if (StrContains(HTTP_req, "ajax_inputs")) {
                        // send rest of HTTP header
                        client.println("Content-Type: text/xml");
                        client.println("Connection: keep-alive");
                        client.println();
                        SetKretnice();
                        // send XML file containing input states
                        XML_response(client);
                    }
                    else {  
                    // =====================================  
                    // web page request
                    // =====================================
                        // send rest of HTTP header
                        client.println("Content-Type: text/html");
                        client.println("Connection: keep-alive");
                        client.println();
                        // send web page
                        webFile = SD.open("index.htm");        // open web page file
                        if (webFile) {
                            while(webFile.available()) {
                                client.write(webFile.read()); // send web page to client
                            }
                            webFile.close();
                        }
                    }
                    // display received HTTP request on serial port
                    Serial.println(HTTP_req);
                    // reset buffer index and all buffer elements to 0
                    req_index = 0;
                    StrClear(HTTP_req, REQ_BUF_SZ);
                    break;
                }
                // every line of text received from the client ends with \r\n
                if (c == '\n') {
                    // last character on line of received text
                    // starting new line with next character read
                    currentLineIsBlank = true;
                } 
                else if (c != '\r') {
                    // a text character was received from client
                    currentLineIsBlank = false;
                }
            } // end if (client.available())
        } // end while (client.connected())
        delay(1);      // give the web browser time to receive the data
        client.stop(); // close the connection
    } // end if (client)
}


// checks if received HTTP request is switching on/off LEDs
// also saves the state of the LEDs
void SetKretnice(void)
{
  
  int count = 0;
  
  
    // Kretnica 1
    if (StrContains(HTTP_req, "K1=1")) {
      
        if( Kretnica_state[count] == 0)
        {  
          Kretnica_state[count] = 1;  // save LED state
          kretnica('s', 1, 1);
        }
    }
    else if (StrContains(HTTP_req, "K1=0")) {
      if( Kretnica_state[count] == 1)
        {    
          Kretnica_state[count] = 0;  // save LED state
          kretnica('s', 1, 0);
        }
    } 
    count++;
    
    // Kretnica 2
    if (StrContains(HTTP_req, "K2=1")) {
      
        if( Kretnica_state[count] == 0)
        {  
          Kretnica_state[count] = 1;  // save LED state
          kretnica('s', 2, 1);
        }
    }
    else if (StrContains(HTTP_req, "K2=0")) {
      if( Kretnica_state[count] == 1)
        {    
          Kretnica_state[count] = 0;  // save LED state
          kretnica('s', 2, 0);
        }
    } 
    count++;


    // Kretnica 3
    if (StrContains(HTTP_req, "K3=1")) {
      
        if( Kretnica_state[count] == 0)
        {  
          Kretnica_state[count] = 1;  // save LED state
          kretnica('s', 3, 1);
        }
    }
    else if (StrContains(HTTP_req, "K3=0")) {
      if( Kretnica_state[count] == 1)
        {    
          Kretnica_state[count] = 0;  // save LED state
          kretnica('s', 3, 0);
        }
    } 
    count++;


    // Kretnica 4
    if (StrContains(HTTP_req, "K4=1")) {
      
        if( Kretnica_state[count] == 0)
        {  
          Kretnica_state[count] = 1;  // save LED state
          kretnica('e', 1, 1);
        }
    }
    else if (StrContains(HTTP_req, "K4=0")) {
      if( Kretnica_state[count] == 1)
        {    
          Kretnica_state[count] = 0;  // save LED state
          kretnica('e', 1, 0);
        }
    } 
    count++;  


    // Kretnica 5
    if (StrContains(HTTP_req, "K5=1")) {
      
        if( Kretnica_state[count] == 0)
        {  
          Kretnica_state[count] = 1;  // save LED state
          kretnica('e', 2, 1);
        }
    }
    else if (StrContains(HTTP_req, "K5=0")) {
      if( Kretnica_state[count] == 1)
        {    
          Kretnica_state[count] = 0;  // save LED state
          kretnica('e', 2, 0);
        }
    } 
    count++;  
    
    // ====================================
    // Nastavitve tirov
    // ====================================    
    
    if (StrContains(HTTP_req, "TIR=6")) {
      
        if( Kretnica_state[0] == 0)
        {  
          Kretnica_state[0] = 1; // k1 = zavij
          kretnica('s', 1, 1);
        }
        if( Kretnica_state[1] == 1)
        {  
          Kretnica_state[1] = 0; // k1 = ravno
          kretnica('s', 2, 0);
        }
    }

    if (StrContains(HTTP_req, "TIR=5")) {
      
        if( Kretnica_state[0] == 0)
        {  
          Kretnica_state[0] = 1; // k1 = zavij
          kretnica('s', 1, 1);
        }
        if( Kretnica_state[1] == 0)
        {  
          Kretnica_state[1] = 1; // k2 = zavij
          kretnica('s', 2, 1);
        }
    }

    if (StrContains(HTTP_req, "TIR=4")) {
      
        if( Kretnica_state[0] == 1)
        {  
          Kretnica_state[0] = 0; // k1 = ravno
          kretnica('s', 1, 0);
        }
        if( Kretnica_state[3] == 1)
        {  
          Kretnica_state[3] = 0; // k4 = ravno
          kretnica('e', 1, 0);
        }
    }   

    if (StrContains(HTTP_req, "TIR=3")) {
      
        if( Kretnica_state[0] == 1)
        {  
          Kretnica_state[0] = 0; // k1 = ravno
          kretnica('s', 1, 0);
        }
        if( Kretnica_state[3] == 0)
        {  
          Kretnica_state[3] = 1; // k4 = zavij
          kretnica('e', 1, 1);
        }
        if( Kretnica_state[4] == 0)
        {  
          Kretnica_state[4] = 1; // k5 = zavij
          kretnica('e', 2, 1);
        }
    }  
    
    
    if (StrContains(HTTP_req, "TIR=2")) {
      
        if( Kretnica_state[0] == 1)
        {  
          Kretnica_state[0] = 0; // k1 = ravno
          kretnica('s', 1, 0);
        }
        if( Kretnica_state[3] == 0)
        {  
          Kretnica_state[3] = 1; // k4 = zavij
          kretnica('e', 1, 1);
        }
        if( Kretnica_state[4] == 1)
        {  
          Kretnica_state[4] = 0; // k5 = ravno
          kretnica('e', 2, 0);
        }

        if( Kretnica_state[2] == 0)
        {  
          Kretnica_state[2] = 1; // k3 = zavij
          kretnica('s', 3, 1);
        }        
    }     
    


    
}

// send the XML file with analog values, switch status
//  and LED status
void XML_response(EthernetClient cl)
{
    int analog_val;            // stores value read from analog inputs
    int count;                 // used by 'for' loops
    
    cl.print("<?xml version = \"1.0\" ?>");
    cl.print("<inputs>");


    // checkbox LED states
    // LED1
    
    for(count=0; count < 5; count++)
    {
      cl.print("<Kretnica>");

      if (Kretnica_state[count] == 1) {
          cl.print("1");
      }
      else {
          cl.print("0");
      }
      cl.println("</Kretnica>");
      
      
      
    }
    

    
    cl.print("</inputs>");
}






// funkcije za kretnice

void kretnica(char tip, int id, int stanje)
{

  int target_kot;
  int out_pin;
  
  byte maska;
  int numberToDisplay;

  
  switch (tip) {
    case 's':
     // ===================================================
     // === servo kretnica
     // ===================================================
     
     switch (id) {
       case  1: // servo 1
         if(stanje == 0) { target_kot = 82; } else { target_kot = 128; }
         maska = B00000010;
         Serial.println(maska); 
       break;
       
       case  2: // servo 2
         if(stanje == 0) { target_kot = 66; } else { target_kot = 114; }
         maska = B00000100;
          Serial.println(maska); 
       break;

       case  3: // servo 3
         if(stanje == 0) { target_kot = 154; } else { target_kot = 83; }
         maska = B00001000;
          Serial.println(maska); 
       break;
     }
     

    // kateremu servotu se odpre napajanje
    numberToDisplay = privzeto ^ maska;   
    digitalWrite(latchPin, LOW);
    shiftOut(dataPin, clockPin, MSBFIRST, numberToDisplay); 
    digitalWrite(latchPin, HIGH);

    myservo.attach(servo_pin);
    myservo.write(target_kot);  // nastavi kot    
    delay(300); // toliko casa ima servo na voljo za premik


    numberToDisplay = privzeto;
    digitalWrite(latchPin, LOW);
    shiftOut(dataPin, clockPin, MSBFIRST, numberToDisplay); 
    digitalWrite(latchPin, HIGH);     

    myservo.detach();  // preneha z oddajanjem
    
     // end servo
    break;
    
    case 'e':
     // ===================================================
     // === elektro kretnica
     // ===================================================    
     

    // glede na kretnico in stanje doloci kateri pin je treba vkljuciti 
      switch (id) {
        case  1: // el.kretnica 1
            if(stanje == 0) { maska = B00010000; } else { maska = B00100000; }
        break;
        case  2: // el.kretnica 2
            if(stanje == 0) { maska = B10000000; } else { maska = B01000000;}
        break;
      }
      
    // na osnovno stanje aplicira masko
     numberToDisplay = privzeto ^ maska; 
     digitalWrite(latchPin, LOW); 
     shiftOut(dataPin, clockPin, MSBFIRST, numberToDisplay); 
     digitalWrite(latchPin, HIGH);  
     delay(50); // toliko casa drzi elektromagnet sklenjen

    // nastavi nazaj osnovno stanje
     numberToDisplay = privzeto;
     digitalWrite(latchPin, LOW); 
     shiftOut(dataPin, clockPin, MSBFIRST, numberToDisplay); 
     digitalWrite(latchPin, HIGH);  
     delay(20);
      
      // end elektro
    break;
  }
  
}











// sets every element of str to 0 (clears array)
void StrClear(char *str, char length)
{
    for (int i = 0; i < length; i++) {
        str[i] = 0;
    }
}

// searches for the string sfind in the string str
// returns 1 if string found
// returns 0 if string not found
char StrContains(char *str, char *sfind)
{
    char found = 0;
    char index = 0;
    char len;

    len = strlen(str);
    
    if (strlen(sfind) > len) {
        return 0;
    }
    while (index < len) {
        if (str[index] == sfind[found]) {
            found++;
            if (strlen(sfind) == found) {
                return 1;
            }
        }
        else {
            found = 0;
        }
        index++;
    }

    return 0;
}
